/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util;

import java.util.Iterator;
import net.creeperhost.ftbbackups.de.piegames.blockmap.repack.io.gsonfire.util.Mapper;

public class IterableMapper<F, T>
implements Iterable<T> {
    private final Iterable<F> source;
    private final Mapper<F, T> mapper;

    private IterableMapper(Iterable<F> source, Mapper<F, T> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<F> sourceIterator = this.source.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return sourceIterator.hasNext();
            }

            @Override
            public T next() {
                Object mapped = IterableMapper.this.mapper.map(sourceIterator.next());
                return mapped;
            }

            @Override
            public void remove() {
            }
        };
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Iterable) {
            Iterator otherIterator = ((Iterable)o).iterator();
            Iterator<T> thisIterator = this.iterator();
            while (thisIterator.hasNext()) {
                if (otherIterator.hasNext()) {
                    Object otherNext;
                    T thisNext = thisIterator.next();
                    if (IterableMapper.areObjectEquals(thisNext, otherNext = otherIterator.next())) continue;
                    return false;
                }
                return false;
            }
            return !otherIterator.hasNext();
        }
        return false;
    }

    private static boolean areObjectEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <F, T> Iterable<T> create(Iterable<F> source, Mapper<F, T> mapper) {
        return new IterableMapper<F, T>(source, mapper);
    }
}

